//
//  Torch.swift
//
//  Copyright © 2020 Apple Inc. All rights reserved.
//


import SpriteKit
import SPCScene
import Canvas

public class Torch: Graphic {
    static let backgrounds = [#imageLiteral(resourceName: "CaveBackground-Torch-128-0.png"),#imageLiteral(resourceName: "CaveBackground-Torch-128-1.png"),#imageLiteral(resourceName: "CaveBackground-Torch-128-2.png"),#imageLiteral(resourceName: "CaveBackground-Torch-128-3.png")]
    
    public init(name: String) {
        super.init(image: Image(with: Torch.backgrounds[0]), name: name)
        
        enableAccessibility(label: name)
        alpha = 0.3
    }
    
    public var shouldActivate: Bool {
        guard let hints = accessibilityHints else {
            return false
        }
        return hints.accessibilityLabel != name
    }
    
    public func activate() {
        guard shouldActivate else { return }
        
        alpha = 1.0
        let anims = Torch.backgrounds.map { Image(with: $0) }
        animate(with: anims, fps: 4, loop: true)
    }

    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}
